#ifndef __CHtmlString__
#define __CHtmlString__

//	===========================================================================

#include "CSystemString.hpp"
using Exponent::Basics::CSystemString;

//	===========================================================================

namespace Exponent
{
	namespace Basics
	{
		/**
		 * @class CHtmlString CHtmlString.hpp
		 * @brief Launchable Html path storage
		 *
		 * Stores a launchable path to an html file or web page. The link can be a file or can be an internet address
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CHtmlString.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CHtmlString : public CSystemString
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			const static char *CHTML_STRING_WEB_LOCATION;		/**< Constructed to be 'http://' */
			const static char *CHTML_STRING_FILE_LOCATION;		/**< Constructed to be 'file://' */

//	===========================================================================

			/**
			 * Construction from a system string
			 * @param string The path to the html file
			 */
			CHtmlString(const CSystemString &string);

			/**
			 * Copy construction
			 * @param string The html string to copy
			 */
			CHtmlString(const CHtmlString &string);

			/**
			 * Construction from a c style string
			 * @param string The path to the html file
			 */
			CHtmlString(const char *string = " ");

			/**
			 * Destruction
			 */
			virtual ~CHtmlString();

//	===========================================================================

			/**
			 * Check if the path stored points to a file
			 * @retval bool True if path points to a file, false otherwise
			 */
			bool isFileLocation();

			/**
			 * Check if the path stored points to a web location
			 * @retval bool True if path points to a web location, false otherwise
			 */
			bool isWebLocation();

			/**
			 * Load the page in the users default browser
			 */
			void loadInBrowser();

			/**
			 * Append the location to the start of the string
			 * @param isHttp If True, CHTML_STRING_WEB_LOCATION is appended to the start\n
			 * If False, CHTML_STRING_FILE_LOCATION is appended to the start
			 */
			void appendLocation(const bool isHttp = true);

//	===========================================================================

		};
	}
}
#endif	// End of CHtmlString